# Carequality Endpoint - Carequality Healthcare Directory ImplementationGuide v1.9.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Carequality Endpoint**

## Resource Profile: Carequality Endpoint 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityEndpoint | *Version*:1.9.0 |
| Active as of 2025-12-22 | *Computable Name*:CarequalityEndpoint |

 
The Carequality Endpoint profile represents information about the endpoints provided by organizations participating in the Carequality Interoperability Framework. The endpoints described can use any supported protocol defined in the respective Carequality Implementation Guide, such as IHE XCA, and need not be FHIR endpoints. 

**Usages:**

* Refer to this Profile: [Carequality Organization](StructureDefinition-CarequalityOrganization.md)
* Examples for this Profile: [Patient Discovery](Endpoint-CQ-orgEndpoint.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.cq|current/StructureDefinition/CarequalityEndpoint)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarequalityEndpoint.csv), [Excel](StructureDefinition-CarequalityEndpoint.xlsx), [Schematron](StructureDefinition-CarequalityEndpoint.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarequalityEndpoint",
  "url" : "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityEndpoint",
  "version" : "1.9.0",
  "name" : "CarequalityEndpoint",
  "title" : "Carequality Endpoint",
  "status" : "active",
  "date" : "2025-12-22T10:00:24-05:00",
  "publisher" : "Carequality",
  "contact" : [
    {
      "name" : "Carequality",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://carequality.org/"
        }
      ]
    }
  ],
  "description" : "The Carequality Endpoint profile represents information about the endpoints provided by organizations participating in the Carequality Interoperability Framework. The endpoints described can use any supported protocol defined in the respective Carequality Implementation Guide, such as IHE XCA, and need not be FHIR endpoints.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Endpoint",
  "baseDefinition" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/SequoiaEndpoint",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Endpoint",
        "path" : "Endpoint"
      },
      {
        "id" : "Endpoint.extension:purposesofuse",
        "path" : "Endpoint.extension",
        "sliceName" : "purposesofuse"
      },
      {
        "id" : "Endpoint.extension:purposesofuse.value[x]",
        "path" : "Endpoint.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://sequoiaproject.org/fhir/sphd/ValueSet/PurposeOfUse"
        }
      },
      {
        "id" : "Endpoint.managingOrganization",
        "path" : "Endpoint.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityOrganization"
            ]
          }
        ]
      }
    ]
  }
}

```
