<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CarequalityOrganization
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Organization</sch:title>
    <sch:rule context="f:Organization">
      <sch:assert test="count(f:extension[@url = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/AdministrativeStatus']) &lt;= 1">extension with URL = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/AdministrativeStatus': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/HubRoutingStatus']) &lt;= 1">extension with URL = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/HubRoutingStatus': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/InitiatorOnly']) &lt;= 1">extension with URL = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/InitiatorOnly': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/org-managing-org']) &lt;= 1">extension with URL = 'https://sequoiaproject.org/fhir/sphd/StructureDefinition/org-managing-org': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:partOf) &lt;= 0">partOf: maximum cardinality of 'partOf' is 0</sch:assert>
      <sch:assert test="count(f:contact) &gt;= 1">contact: minimum cardinality of 'contact' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Organization/f:address</sch:title>
    <sch:rule context="f:Organization/f:address">
      <sch:assert test="count(f:city) &gt;= 1">city: minimum cardinality of 'city' is 1</sch:assert>
      <sch:assert test="count(f:state) &gt;= 1">state: minimum cardinality of 'state' is 1</sch:assert>
      <sch:assert test="count(f:postalCode) &gt;= 1">postalCode: minimum cardinality of 'postalCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
