# Carequality Implementer - Carequality Healthcare Directory ImplementationGuide v1.11.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Carequality Implementer**

## Resource Profile: Carequality Implementer 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityImplementer | *Version*:1.11.0 |
| Active as of 2026-02-12 | *Computable Name*:CarequalityImplementer |

 
The Carequality Implementer profile represents the adopters of the Carequality Interoperability Framework, such as a health data sharing network or service platform. 

**Usages:**

* Examples for this Profile: [Implementer Hospital](Organization-Carequality-Implementer-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.cq|current/StructureDefinition/CarequalityImplementer)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarequalityImplementer.csv), [Excel](StructureDefinition-CarequalityImplementer.xlsx), [Schematron](StructureDefinition-CarequalityImplementer.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarequalityImplementer",
  "url" : "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityImplementer",
  "version" : "1.11.0",
  "name" : "CarequalityImplementer",
  "title" : "Carequality Implementer",
  "status" : "active",
  "date" : "2026-02-12T09:57:09-05:00",
  "publisher" : "Carequality",
  "contact" : [
    {
      "name" : "Carequality",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://carequality.org/"
        }
      ]
    }
  ],
  "description" : "The Carequality Implementer profile represents the adopters of the Carequality Interoperability Framework, such as a health data sharing network or service platform.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityOrganization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.type:sequoiaorgtype",
        "path" : "Organization.type",
        "sliceName" : "sequoiaorgtype",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
              "code" : "Implementer"
            }
          ]
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "max" : "0"
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "min" : 1
      }
    ]
  }
}

```
