# Artifacts Summary - Carequality Healthcare Directory ImplementationGuide v1.10.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [Carequality Organization](StructureDefinition-CarequalityOrganization.md) | This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the Carequality Connection or Carequality Implementer profiles. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Carequality Connection](StructureDefinition-CarequalityConnection.md) | The Carequality Connection profile represents an organization that participates in exchange activities via Carequality through a Carequality Implementer, such as a health system that participates via its EHR vendor, who is an implementer. |
| [Carequality Endpoint](StructureDefinition-CarequalityEndpoint.md) | The Carequality Endpoint profile represents information about the endpoints provided by organizations participating in the Carequality Interoperability Framework. The endpoints described can use any supported protocol defined in the respective Carequality Implementation Guide, such as IHE XCA, and need not be FHIR endpoints. |
| [Carequality Implementer](StructureDefinition-CarequalityImplementer.md) | The Carequality Implementer profile represents the adopters of the Carequality Interoperability Framework, such as a health data sharing network or service platform. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Connection Hospital](Organization-Carequality-Connection-example.md) | Carequality Connection Example |
| [Implementer Hospital](Organization-Carequality-Implementer-example.md) | Carequality Implementer Example |
| [Patient Discovery](Endpoint-CQ-orgEndpoint.md) | Carequality Endpoint Example |

