# Carequality Organization - Carequality Healthcare Directory ImplementationGuide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Carequality Organization**

## Resource Profile: Carequality Organization ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityOrganization | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:CarequalityOrganization |

 
This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the Carequality Connection or Carequality Implementer profiles. 

**Usages:**

* Derived from this Profile: [Carequality Connection](StructureDefinition-CarequalityConnection.md) and [Carequality Implementer](StructureDefinition-CarequalityImplementer.md)
* Refer to this Profile: [Carequality Endpoint](StructureDefinition-CarequalityEndpoint.md) and [Carequality Organization](StructureDefinition-CarequalityOrganization.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.cq|current/StructureDefinition/CarequalityOrganization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarequalityOrganization.csv), [Excel](StructureDefinition-CarequalityOrganization.xlsx), [Schematron](StructureDefinition-CarequalityOrganization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarequalityOrganization",
  "url" : "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityOrganization",
  "version" : "1.10.0",
  "name" : "CarequalityOrganization",
  "title" : "Carequality Organization",
  "status" : "active",
  "date" : "2026-01-20T11:04:20-05:00",
  "publisher" : "Carequality",
  "contact" : [
    {
      "name" : "Carequality",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://carequality.org/"
        }
      ]
    }
  ],
  "description" : "This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the Carequality Connection or Carequality Implementer profiles.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/SequoiaOrganization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension:purposesofuse",
        "path" : "Organization.extension",
        "sliceName" : "purposesofuse"
      },
      {
        "id" : "Organization.extension:purposesofuse.value[x]",
        "path" : "Organization.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://sequoiaproject.org/fhir/sphd/ValueSet/PurposeOfUse"
        }
      },
      {
        "id" : "Organization.extension:usecases",
        "path" : "Organization.extension",
        "sliceName" : "usecases",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom:phone",
        "path" : "Organization.telecom",
        "sliceName" : "phone",
        "max" : "1"
      },
      {
        "id" : "Organization.telecom:email",
        "path" : "Organization.telecom",
        "sliceName" : "email",
        "max" : "1"
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "country"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organization.address.extension",
        "path" : "Organization.address.extension",
        "min" : 1
      },
      {
        "id" : "Organization.address.text",
        "path" : "Organization.address.text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.country",
        "path" : "Organization.address.country",
        "min" : 1
      },
      {
        "id" : "Organization.address:united-states-address",
        "path" : "Organization.address",
        "sliceName" : "united-states-address",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address:united-states-address.city",
        "path" : "Organization.address.city",
        "min" : 1
      },
      {
        "id" : "Organization.address:united-states-address.state",
        "path" : "Organization.address.state",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "Two letter USPS alphabetic codes.",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-usps-state"
        }
      },
      {
        "id" : "Organization.address:united-states-address.postalCode",
        "path" : "Organization.address.postalCode",
        "min" : 1
      },
      {
        "id" : "Organization.address:united-states-address.country",
        "path" : "Organization.address.country",
        "fixedString" : "US"
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityOrganization"
            ]
          }
        ]
      },
      {
        "id" : "Organization.contact.purpose",
        "path" : "Organization.contact.purpose",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact.name",
        "path" : "Organization.contact.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact.telecom",
        "path" : "Organization.contact.telecom",
        "min" : 2
      },
      {
        "id" : "Organization.contact.telecom:phone",
        "path" : "Organization.contact.telecom",
        "sliceName" : "phone",
        "min" : 1
      },
      {
        "id" : "Organization.contact.telecom:email",
        "path" : "Organization.contact.telecom",
        "sliceName" : "email",
        "min" : 1
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityEndpoint"
            ]
          }
        ]
      }
    ]
  }
}

```
