# Carequality Connection - Carequality Healthcare Directory ImplementationGuide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Carequality Connection**

## Resource Profile: Carequality Connection 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityConnection | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:CarequalityConnection |

 
The Carequality Connection profile represents an organization that participates in exchange activities via Carequality through a Carequality Implementer, such as a health system that participates via its EHR vendor, who is an implementer. 

**Usages:**

* Examples for this Profile: [Connection Hospital](Organization-Carequality-Connection-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.cq|current/StructureDefinition/CarequalityConnection)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarequalityConnection.csv), [Excel](StructureDefinition-CarequalityConnection.xlsx), [Schematron](StructureDefinition-CarequalityConnection.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarequalityConnection",
  "url" : "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityConnection",
  "version" : "1.10.0",
  "name" : "CarequalityConnection",
  "title" : "Carequality Connection",
  "status" : "active",
  "date" : "2026-01-20T11:04:20-05:00",
  "publisher" : "Carequality",
  "contact" : [
    {
      "name" : "Carequality",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://carequality.org/"
        }
      ]
    }
  ],
  "description" : "The Carequality Connection profile represents an organization that participates in exchange activities via Carequality through a Carequality Implementer, such as a health system that participates via its EHR vendor, who is an implementer.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/cq/StructureDefinition/CarequalityOrganization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension",
        "path" : "Organization.extension",
        "min" : 2
      },
      {
        "id" : "Organization.extension:org-managing-org",
        "path" : "Organization.extension",
        "sliceName" : "org-managing-org",
        "min" : 1
      },
      {
        "id" : "Organization.type:sequoiaorgtype",
        "path" : "Organization.type",
        "sliceName" : "sequoiaorgtype",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
              "code" : "Connection"
            }
          ]
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "min" : 1
      }
    ]
  }
}

```
